*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Bensulide Oxon                                       *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";
libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/

*==> Human vs. rat;

data BensulideOxon;
     set epa.BensulideOxon;
run;
proc sort data=BensulideOxon;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\BensulideOxon - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=BensulideOxon);
ods rtf close;


title "final model 3: human vs. rat";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=BensulideOxon /*itdetails*/ tech=newrap lis=3;
      PARMS ha=0.7222
			hb=1.9865	
			ra=0.5253
			rb=0.8894	
			gha=3.8327	ghab=0.7733		ghb=3.5488
			gra=5.2588	grab=1.4066		grb=3.8932
			S2E=0.1513;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-3 + H_I__M + rrb*Rat*1e-3 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha/100, 
												 		 ghab/10, ghb/10,
														 0,    	  0,   gra/100,
														 0,       0,   grab/10, grb/10]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\BensulideOxon human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=BensulideOxon, model=3)
ods rtf close;
%Calculate_Ki(chemical=BensulideOxon, Hadj=1e-3, Radj=1e-3);


*==> Adult vs. Infant;

title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=BensulideOxon(where=(Human=1)) tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.6230	adB=.1639
			ia=.9321 iB=.2469
			gha=.3199 	ghab=.7304	ghb=.3539
			S2E=0.1386;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-2 + H_I__M*adult + rib*1e-2*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-2, ghb*1e-2]) SUBJECT=ID out=RandID_AI; 
	  ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\BensulideOxon Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=BensulideOxon, model=2);
ods rtf close;




*===> Male vs. female;
title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=BensulideOxon(where=(Human=1)) method=firo tech=nrridg lis=3 maxiter=100000;
      PARMS ma=.65 mb= .20
			fa=.72 fB=.17
			gha=.49 	ghab=.13	ghb=.51
			S2E=.1353;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
 			PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-2 + H_I__M*male + rfb*female*1e-2 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-2]) SUBJECT=ID  out=RandID_MF;
	  ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\BensulideOxon Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=BensulideOxon, model=2);
ods rtf close;





*===> Caucasian vs. Others;

title "model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=BensulideOxon(where=(Human=1)) method=firo tech=newrap lis=3 maxiter=100000;
      PARMS ca=.7027	cB=.1842
			ora=.6244 orB=.1708
			gha=.4903	ghab=.1240	ghb=.5169
			S2E=.1370;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-2 + H_I__M*caucasian + rorb*otherrace*1e-2 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-2]) SUBJECT=ID out=RandID_CO; 
	  ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\BensulideOxon Caucasian-Other.rtf" startpage=no;
%DiagnosticsCO(chemical=BensulideOxon, model=2);
ods rtf close;

